%define module_name WWW-Scraper-Wikipedia-ISO3166
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Capture/Tiny.pm) perl(Carp.pm) perl(Config.pm) perl(Config/Tiny.pm) perl(Cwd.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(DBIx/Admin/CreateTable.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/ShareDir.pm) perl(File/Slurper.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(HTTP/Tiny.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(List/AllUtils.pm) perl(List/Compare.pm) perl(Log/Handler.pm) perl(Module/Build.pm) perl(Mojo/DOM.pm) perl(Moo.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Pod/Usage.pm) perl(Socket.pm) perl(Sort/Naturally.pm) perl(Test2/Bundle/Extended.pm) perl(Text/Xslate.pm) perl(Types/Standard.pm) perl(Unicode/CaseFold.pm) perl(Unicode/Normalize.pm) perl(YAML/Tiny.pm) perl(open.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.00
Release: alt1
Summary: Gently scrape Wikipedia for ISO3166-2 data
Group: Development/Perl
License: see LICENSE
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RS/RSAVAGE/%{module_name}-%{version}.tgz
BuildArch: noarch

%description
`WWW::Scraper::Wikipedia::ISO3166' is a pure Perl module.

It is used to download various ISO3166-related pages from Wikipedia, and to then import data
(scraped from those pages) into an SQLite database.

The pages have already been downloaded, so that phase only needs to be run when pages are updated.

Likewise, the data has been imported.

This means you would normally only ever use the database in read-only mode.

Its components are:

=over 4

=item o scripts/get.country.page.pl

1: Downloads the ISO3166-1_alpha-3 page from Wikipedia.

Input: http://en.wikipedia.org/wiki/ISO_3166-1_alpha-3.

Output: data/en.wikipedia.org.wiki.ISO_3166-2.3.html.

2: Downloads the ISO3166-2 page from Wikipedia.

Input: http://en.wikipedia.org/wiki/ISO_3166-2.

Output: data/en.wikipedia.org.wiki.ISO_3166-2.html.

=item o scripts/populate.countries.pl

Imports country data into an SQLite database.

inputs: data/en.wikipedia.org.wiki.ISO_3166-2.html, data/en.wikipedia.org.wiki.ISO_3166-2.3.html.

Output: share/www.scraper.wikipedia.iso3166.sqlite.

=item o scripts/get.subcountry.page.pl and scripts/get.subcountry.pages.pl

Downloads each countries' corresponding subcountries page.

Source: http://en.wikipedia.org/wiki/ISO_3166:$code2.html.

Output: data/en.wikipedia.org.wiki.ISO_3166-2.$code2.html.

=item o scripts/populate.subcountry.pl and scripts/populate.subcountries.pl

Imports subcountry data into the database.

Source: data/en.wikipedia.org.wiki.ISO_3166-2.$code2.html.

Output: share/www.scraper.wikipedia.iso3166.sqlite.

Note: When the distro is installed, this SQLite file is installed too.
See the Where is the database? entry elsewhere in this document for details.

=item o scripts/export.as.csv.pl -c c.csv -s s.csv

Exports the country and subcountry data as CSV.

Input: share/www.scraper.wikipedia.iso3166.sqlite.

Output: data/countries.csv and data/subcountries.csv.

=item o scripts/export.as.html -w c.html

Exports the country and subcountry data as HTML.

Input: share/www.scraper.wikipedia.iso3166.sqlite.

Output: data/iso.3166-2.html.

On-line: http://savage.net.au/Perl-modules/html/WWW/Scraper/Wikipedia/ISO3166/iso.3166-2.html.

=item o scripts/get.statoids.pl

Downloads some pages from http://statoids.com in case one day we need to convert from FIPS to ISO 3166-2.

See data/List_of_FIPS_region_codes_*.html.

=item o scripts/populate.fips.codes.pl

This reads the files output by scripts/get.statoids.pl and produces 2 reports, data/wikipedia.fips.codes.txt
and data/wikipedia.fips.mismatch.log. These are discussed in the What FIPS data is included? entry elsewhere in this document

=item o scripts/test.nfc.pl

See the Why did you use the Unicode::Normalize manpage's NFC() for sorting? entry elsewhere in this document for a discussion of this script.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changelog.ini README LICENSE Changes
%perl_vendor_privlib/W*
%perl_vendor_privlib/auto/*

%changelog
