Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(ExtUtils/CBuilder.pm) perl(JSON.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
%add_findreq_skiplist %perl_vendor_privlib/WWW/Search/* 
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-WWW-Search
Version:        2.519
Release:        alt2_17
Summary:        Virtual base class for WWW searches
# Automatically converted from old format: BSD - review is highly recommended.
License:        LicenseRef-Callaway-BSD
URL:            https://metacpan.org/release/WWW-Search
Source0:        https://cpan.metacpan.org/authors/id/M/MT/MTHURN/WWW-Search-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(Env.pm)
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Module/Install/Metadata.pm)
BuildRequires:  perl(Module/Install/Scripts.pm)
BuildRequires:  perl(Module/Install/WriteAll.pm)
# Run-time
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Bit/Vector.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(CGI.pm)
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Date/Manip.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(File/Copy.pm)
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(File/Slurp.pm)
BuildRequires:  perl(File/Spec/Functions.pm)
BuildRequires:  perl(Getopt/Long.pm)
BuildRequires:  perl(HTML/TreeBuilder.pm)
BuildRequires:  perl(HTTP/Cookies.pm)
BuildRequires:  perl(HTTP/Request.pm)
BuildRequires:  perl(HTTP/Response.pm)
BuildRequires:  perl(HTTP/Status.pm)
# LWP::Debug not used at tests
BuildRequires:  perl(LWP/MemberMixin.pm)
BuildRequires:  perl(LWP/RobotUA.pm)
BuildRequires:  perl(LWP/UserAgent.pm)
BuildRequires:  perl(Pod/Usage.pm)
BuildRequires:  perl(POSIX.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(URI.pm)
BuildRequires:  perl(URI/Escape.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  sed
# Tests
BuildRequires:  perl(blib.pm)
BuildRequires:  perl(ExtUtils/testlib.pm)
# Getopt::Long not used
BuildRequires:  perl(IO/Capture/Stderr.pm)
BuildRequires:  perl(Test/File.pm)
# Optional tests
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
Requires:       perl(LWP/Debug.pm)
Source44: import.info


%description
This class is the parent for all access methods supported by the WWW::Search
library. This library implements a Perl API to web-based search engines. See
README for a list of search engines currently supported, and for a lot of
interesting high-level information about this distribution. Search results can
be limited, and there is a pause between each request to avoid overloading
either the client or the server.


%prep
%setup -q -n WWW-Search-%{version}
# Remove bundled modules
rm -rf inc
sed -i -e '/^inc\//d' MANIFEST


%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build


%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
# %{_fixperms} $RPM_BUILD_ROOT/*


%check
make test

%files
# LICENSE is empty
%doc Changes README
%{_bindir}/AutoSearch
%{_bindir}/WebSearch
%{perl_vendor_privlib}/*
%{_mandir}/man1/*Search.1*


%changelog
