%define module_name WWW-Shopify-Liquid
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Clone.pm) perl(Data/Compare.pm) perl(Date/Parse.pm) perl(DateTime.pm) perl(DateTime/Format/Strptime.pm) perl(Devel/StackTrace.pm) perl(Digest/MD5.pm) perl(Encode.pm) perl(File/Find.pm) perl(File/Slurp.pm) perl(File/stat.pm) perl(HTML/Entities.pm) perl(JSON.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(Math/Round.pm) perl(Module/Build.pm) perl(Module/Find.pm) perl(Pod/Usage.pm) perl(Scalar/Util.pm) perl(Text/Unaccent/PurePerl.pm) perl(URI/Escape.pm) perl(parent.pm) perl(re/engine/RE2.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt3
Summary: Fully featured liquid preprocessor with shopify tags & filters added in.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AD/ADAMDH/%{module_name}-%{version}.tar.gz

%description
A concise and clear liquid processor. Runs a superset of what Shopify can do. For a strict shopify implementation
see the Template::Liquid manpage for one that emulates all the quirks and ridiculousness of the real thing, but without the tags.
(Meaning no actual arithemtic is literal tags without filters, insanity on acutal number processing and conversion,
insane array handling, no real optimization, or partial AST reduction, etc.., etc..).

Combines a lexer, parser, optimizer and a renderer. Can be invoked in any number of ways. Simplest is to use the sub this module exports,
liquid_render_file.

_use WWW::Shopify::Liquid qw/liquid_render_file/;
_
_$contents = liquid_render_file({ collection => { handle => "test" } }, "myfile.liquid");
_print $contents;
_
This is the simplest method. There are auxiliary methods which provide a lot of flexibility over how you render your
liquid (see below), and an OO interface.

This method represents the whole pipeline, so to get an overview of this module, we'll describe it here.
Fundamentally, what liquid_render_file does, is it slurps the whole file into a string, and then passes that string to
the lexer. This then generates a stream of tokens. These tokens are then transformed into an abstract syntax tree, by the
the parser if the syntax is valid. This AST represents the canonical form of the file, and can, from here, either
transformed back into almost the same file, statically optimized to remove any unecessary calls, or partially optimized to
remove branches of the tree for which you have variables to fill at this time, though both these steps are optional.

Finally, these tokens are passed to the renderer, which interprets the tokens and then produces a string representing the
final content that can be printed.

Has better error handling than Shopify's liquid processor, so if you use this to validate your liquid, you should get better
errors than if you're simply submitting them. This module is integrated into the the Padre::Plugin::Shopify manpage module, so if...

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%perl_vendor_autolib/*
%perl_vendor_privlib/W*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
