%define module_name WWW-YaCyBlacklist
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(HTML/LinkExtor.pm) perl(IO/All.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(LWP/UserAgent.pm) perl(Moose.pm) perl(Moose/Util/TypeConstraints.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/CPAN/Changes.pm) perl(Test/CPAN/Meta.pm) perl(Test/CPAN/Meta/JSON.pm) perl(Test/DistManifest.pm) perl(Test/EOL.pm) perl(Test/Kwalitee.pm) perl(Test/MinimumVersion.pm) perl(Test/Mojibake.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Portability/Files.pm) perl(Test/Synopsis.pm) perl(Test/Vars.pm) perl(Test/Version.pm) perl(URI.pm) perl(URI/URL.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.8
Release: alt1
Summary: a Perl module to parse and execute YaCy blacklists
Group: Development/Perl
License: perl
URL: https://ingram-braun.net/erga/the-www-yacyblacklist-module/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/I/IB/IBRAUN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use WWW::YaCyBlacklist;

    my $ycb = WWW::YaCyBlacklist->new( { 'use_regex' => 1 } );
    $ycb->read_from_array(
        'test1.co/fullpath',
        'test2.co/.*',
    );
    $ycb->read_from_files(
        '/path/to/1.black',
        '/path/to/2.black',
    );

    print "Match!" if $ycb->check_url( 'http://test1.co/fullpath' );
    my @urls = (
        'https://www.perlmonks.org/',
        'https://metacpan.org/',
    );
    my @matches = $ycb->find_matches( @urls );
    my @nonmatches = $ycb->find_non_matches( @urls );

    $ycb->sortorder( 1 );
    $ycb->sorting( 'alphabetical' );
_$ycb->sortorder( '/path/to/new.black' );
    $ycb->store_list( );

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/W*

%changelog
