# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Load.pm) perl(Exporter.pm) perl(File/ShareDir.pm) perl(FindBin.pm) perl(Module/Build/Tiny.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(MooseX/Singleton.pm) perl(Params/Validate.pm) perl(Test/Differences.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.06
%define module_name Web-Library
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Manager for wrappers around client-side libraries
Group: Development/Perl
License: perl
URL: https://github.com/marcelgruenauer/Web-Library

Source0: http://cpan.org.ua/authors/id/M/MA/MARCEL/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
There are well-established ways for web applications to manage server-side
dependencies, like `Makefile.PL' or `cpanfile' - but what about client-side
dependencies?

So you develop and maintain a number of web applications, and all of them use
some client-side libraries like jQuery or Twitter Bootstrap or Underscore.js.
You have to copy the relevant JavaScript, CSS and image files to a directory
containing static files for each web application. This involves quite a bit of
copying around and version maintenance. Web::Library can help you.

The idea behind Web::Library and its related distributions is that client-side
libraries are installed as shared files of standard CPAN distributions.
Web::Library itself is a manager for those libraries. A web application that
wishes to use one or more client-side libraries can tell Web::Library to
include either the latest or a specific version of those libraries. These
managed libraries can then be used as static files with web application
frameworks. In the case of the Catalyst manpage you might use
the Catalyst::Plugin::Static::Simple manpage as shown in the synopsis.

Web::Library is a singleton object, so you can add client-side libraries in
different parts of your application. For example, you might have common
librares that are included in all of your web applications, but then also want
to manage application-specific libraries.

Only client-side libraries whose license permits redistribution can be managed
this way. Forunately, most, if not all, popular client-side libraries have such
permissive licenses.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/W*

%changelog
