%define module_name Web-Sitemap
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Compress/Gzip.pm) perl(IO/Uncompress/Gunzip.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.903
Release: alt1
Summary: Simple way to generate sitemap files with paging support.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BR/BRTASTIC/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Also support for Google images format:

_my @img_urls = (
__
__# Foramt 1
__{ 
___loc => 'http://test1.ru/', 
___images => { 
____caption_format => sub { 
_____my ($iterator_value) = @_; 
_____return sprintf('.'.O.'.' - .'.'.'.' %%d', $iterator_value); 
____},
____loc_list => [
_____'http://img1.ru/', 
_____'http://img2.ru'
____] 
___} 
__},

__# Foramt 2
__{ 
___loc => 'http://test11.ru/', 
___images => { 
____caption_format_simple => '.'.O.'.' - .'.'.'.'',
____loc_list => ['http://img11.ru/', 'http://img21.ru'] 
___} 
__},

__# Format 3
__{ 
___loc => 'http://test122.ru/', 
___images => { 
____loc_list => [
_____{ loc => 'http://img122.ru/', caption => 'image #1' },
_____{ loc => 'http://img133.ru/', caption => 'image #2' },
_____{ loc => 'http://img144.ru/', caption => 'image #3' },
_____{ loc => 'http://img222.ru', caption => 'image #4' }
____] 
___} 
__}
_);


_# Result:

_<?xml version="1.0" encoding="UTF-8"?>
_<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
_<url>
__<loc>http://test1.ru/</loc>
__<image:image>
___<loc>http://img1.ru/</loc>
___<caption><![CDATA[.'.O.'.' - .'.'.'.' 1]]></caption>
__</image:image>
__<image:image>
___<loc>http://img2.ru</loc>
___<caption><![CDATA[.'.O.'.' - .'.'.'.' 2]]></caption>
__</image:image>
_</url>
_<url>
__<loc>http://test11.ru/</loc>
__<image:image>
___<loc>http://img11.ru/</loc>
___<caption><![CDATA[.'.O.'.' - .'.'.'.' 1]]></caption>
__</image:image>
__<image:image>
___<loc>http://img21.ru</loc>
___<caption><![CDATA[.'.O.'.' - .'.'.'.' 2]]></caption>
__</image:image>
_</url>
_<url>
__<loc>http://test122.ru/</loc>
__<image:image>
___<loc>http://img122.ru/</loc>
___<caption><![CDATA[image #1]]></caption>
__</image:image>
__<image:image>
___<loc>http://img133.ru/</loc>
___<caption><![CDATA[image #2]]></caption>
__</image:image>
__<image:image>
___<loc>http://img144.ru/</loc>
___<caption><![CDATA[image #3]]></caption>
__</image:image>
__<image:image>
___<loc>http://img222.ru</loc>
___<caption><![CDATA[image #4]]></caption>
__</image:image>
_</url>
_</urlset>

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE
%perl_vendor_privlib/W*

%changelog
