%define module_name WebService-ADSBExchange
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Headers.pm) perl(HTTP/Request.pm) perl(JSON/Parse.pm) perl(LWP/UserAgent.pm) perl(Moose.pm) perl(Test2/V0.pm) perl(Types/Standard.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.222600
Release: alt1
Summary: Interface with the ADSBExchange API
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TY/TYUPYRCML/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This interface helps the user to communicate with the API at adsbexchange.com to track aircraft 
information.  The API could be used, for example, to alert you when an aircraft is within four 
miles and flying under 5000 feet, or when an aircraft squawks 7700.  To use the API you need to 
register at https://rapidapi.com/adsbx/api/adsbexchange-com1 and buy a subscription.

To use the module, you first create a WebService::ADSBExchange object.  The new() function takes 
one parameter: your API Key.   

 my $adsb = WebService::ADSBExchange->new( key => $key );
 
... and then you are ready to use the methods on your $adsb object.  If you send no key you will 
get an error message from the module.  If you send an invalid key, the module will use it and  
you'll get an error from the API.

The API URL is fixed in the module, but if it changes you can also pass the new one to the new()  
function:

 my $adsb = WebService::ADSBExchange->new( key => $key, api_url => 'new_api_url.com' );

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README
%perl_vendor_privlib/W*

%changelog
