%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DB_File.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON.pm) perl(Test/More.pm) perl(WebService/Amazon/Route53.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.4
%define module_name WebService-Amazon-Route53-Caching
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.4
Release: alt1
Summary: Caching layer on top of WebService::Amazon::Route53.
Group: Development/Perl
License: perl
URL: https://github.com/skx/WebService--Amazon--Route53--Caching/

Source0: http://cpan.org.ua/authors/id/S/SK/SKX/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module overrides the base behaviour of the the WebService::Amazon::Route53 manpage
object to provide two specific speedups:

=over 8

=item We force the use of HTTP Keep-Alive when accessing the remote Amazon API end-point.

=item We cache the mapping between zone-names and Amazon IDs

=back

The reason for the existance of this module was observed performance
issues with the native client.  A user of the Route53 API wishes to use
the various object methods against zones, but the Amazon API requires
that you use their internal IDs.

For example rather than working with a zone such as "steve.org.uk", you
must pass in a zone_id of the form "123ZONEID".  Discovering the ID
of a zone is possible via get_hosted_zone method.

Unfortunately the implementation of the get_hosted_zone method essentially
boils down to fetching all possible zones, and then performing a string
comparison on their names.

This module was born to cache the ID-data of individual zones, allowing
significant speedups when dealing with a number of zones.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc ChangeLog README.md
%perl_vendor_privlib/W*

%changelog
