# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Accessor/Fast.pm) perl(LWP/UserAgent.pm) perl(Module/Build.pm) perl(Module/Build/Compat.pm) perl(Test/More.pm) perl(URI.pm) perl(XML/Liberal.pm) perl(base.pm) perl(version.pm) perl(Test/Perl/Critic.pm)
# END SourceDeps(oneline)
%define module_version 0.1
%define module_name WebService-Google-Contact
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1
Release: alt1
Summary: Simple Interface for Google Contact API.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AB/ABUI/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
# step1 => make uri for google authorization.
    use CGI;
    use WebService::Google::Contact;

    my $google_contact = WebService::Google::Contact->new;
    my $next_uri = 'http://example.com/?next=1';
    my $google_login_uri = $google_contact->uri_to_login( $next_uri );

    my $q = CGI->new;

    print $q->redirect( $google_login_uri );

    # step2 => catch the token and go to verify stage.
    use CGI;
    use WebService::Google::Contact;

    my $q = CGI->new;
    my $token = $q->param('token');
    my $google_contact = WebService::Google::Contact->new;
    
    $google_contact->verify( $token ) or die;

    # success verify!
    my $email = $google_contact->email;
    my $contacts = $google_contact->get_contact; # $contacts is $emais's contact list.

    warn sprintf('Welcome %%s!', $email);


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/W*

%changelog
