%define module_version 0.11
%define module_name WebService-Xero
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config/Tiny.pm) perl(Crypt/OpenSSL/RSA.pm) perl(Data/Random.pm) perl(Digest/MD5.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(HTTP/Request.pm) perl(JSON.pm) perl(JSON/PP.pm) perl(LWP/UserAgent.pm) perl(Mozilla/CA.pm) perl(Net/OAuth.pm) perl(Test/More.pm) perl(URI/Encode.pm) perl(XML/Simple.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: Access Xero Accounting Package Public and Private Applicaiton API
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LO/LOCALSHOP/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
The Xero API is a RESTful web service and uses the OAuth (v1.0a) https://oauth.net/core/1.0a/ protocol to authenticate 3rd party applications.

WebService::Xero aims primarily to simplify the authenticated access to Xero API service end-point by encapuslating the OAuth requirements.

To enable API access see the Xero Getting started guide

https://developer.xero.com/documentation/getting-started/getting-started-guide/

and with the Configured Application Authentication Credentials from https://api.xero.com/Application 

this module will allow to to access the API Services.

Xero provides Private, Public and Partner Applications. This module currently supports the Private and Public Application types.

The simplest implementation uses a Private Application as follows:

    use WebService::Xero::Agent::PrivateApplication;
    use Data::Dumper;

    my $xero = WebService::Xero::Agent::PrivateApplication->new( CONSUMER_KEY    => 'YOUR_OAUTH_CONSUMER_KEY', 
                                                          CONSUMER_SECRET => 'YOUR_OAUTH_CONSUMER_SECRET', 
                                                          KEYFILE         => "/path/to/privatekey.pem" 
                                                          );
    ## AND THEN ACCESS THE API POINTS

    my $contact_struct = $xero->do_xero_api_call( 'https://api.xero.com/api.xro/2.0/Contacts' );

    print Dumper $contact_struct; ## should contain an array of hashes containing contact data.
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/W*

%changelog
