# BEGIN SourceDeps(oneline):
BuildRequires: perl(Clone.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(HTTP/Status.pm) perl(JSON/PP.pm) perl(Kelp.pm) perl(Kelp/Module/YAML.pm) perl(List/Util.pm) perl(Moo.pm) perl(Path/Tiny.pm) perl(Role/Tiny.pm) perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Test/Pod.pm) perl(Text/Levenshtein.pm) perl(Time/Piece.pm) perl(Try/Tiny.pm) perl(YAML/PP.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name Whelk
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.04
Release: alt1
Summary: A fortified API framework based on Kelp
Group: Development/Perl
License: perl
URL: https://kelp-framework.github.io#whelk

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BR/BRTASTIC/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
=begin html

<p style="text-align: center"><img width="80%%" src="https://raw.githubusercontent.com/Kelp-framework/Art/master/whelk/logo_wide.png" alt="logo"></p>
<p style="text-align: center"><b>A fortified web API framework</b></p>

=end html

Whelk is an API framework which helps you create correct, fast,
self-documenting APIs. It's easy to learn, fun to work with and extremely
customizable. It can be run either standalone as a the Plack manpage application, or
inside a the Kelp manpage application as a module.

Whelk is integrated with OpenAPI/Swagger and automatically generates a document
according to spec v3 rules. All the data for the document is taken directly
from your endpoint validation rules, which ensures only minimal effort is
needed to generate a documentation for your project. The resulting
documentation can be beautifully visualized using OpenAPI tools like Swagger
UI.

To get started, take a look at the Whelk::Manual manpage.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE
%perl_vendor_privlib/W*
%perl_vendor_privlib/K*

%changelog
