%define module_name WordList
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Role/Tiny.pm) perl(Role/Tiny/With.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.7.11
Release: alt1
Summary: Word lists
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/WordList

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch
Provides: perl(WordList.pm) = 0.401

%description
EARLY DEVELOPMENT, SPECIFICATION MIGHT STILL CHANGE CONSIDERABLY.

`WordList::*' modules are modules that contain, well, list of words. This
module, `WordList', serves as a base class and establishes convention for such
modules.

`WordList' is an alternative interface for the Games::Word::Wordlist manpage and
`Games::Word::Wordlist::*'. Its main difference is: `WordList::*' modules are
designed to have low startup overhead. This makes it more suitable for use in
CLI scripts which often only want to pick a word from one or several lists.

Words (or phrases) must be put in __DATA__ section, *sorted*, one per line. By
putting it in the __DATA__ section, perl doesn't have to parse the list. To
search for words or picking some random words from the list, the module need not
slurp the whole list into memory (and will not do so unless explicitly
instructed.) Sorting must be asciibetical/by Unicode codepoint. This makes it
more convenient to diff different versions of the module, as well as performing
binary search.

Since this is a new and non-backward compatible interface from
Games::Word::Wordlist, I also make some other changes:

=over

=item * Namespace is put outside `Games::'

Because obviously word lists are not only useful for games.

=item * Interface is simpler

The methods provided are just:

- `pick' (pick one or several random entries)

- `word_exists' (check whether a word is in the list)

- `each_word' (run code for each entry)

- `all_words' (return all the words in a list)

A couple of other functions might be added, with careful consideration.

=item * Namespace is more language-neutral and not English-centric

=back

TODOS:

=over

=item * Interface for random pick from a subset

Pick $n words of length $L.

Pick $n words matching regex $re.

=item * Interface to enable faster lookup/caching

=back
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/W*

%changelog
