# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(WordList.pm)
# END SourceDeps(oneline)
%define module_name WordList-ID-BIP39
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: Indonesian (proposed) word list for BIP 39
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/WordList-ID-BIP39

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is the proposed Indonesian word list for BIP 39. The list was formed by
selecting the most common Indonesian words from Wikipedia (see
the WordLists::ID::Common manpage repository) that are at least 4 characters long and are
not found in the other BIP 39 wordlists (EN,
ES, FR,
FR). Characteristics of this wordlist:

=over

=item * Selected from most common words (Wikipedia Indonesia corpus).

=item * At least 4 characters long.

=item * Words can be uniquely determined typing the first 4 characters.

=item * Words are not found in the other languages' BIP wordlist, so language detection is easy.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/W*

%changelog
