%define module_version 0.08
%define module_name Workflow-Lite
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Class/Load.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Moose/Exporter.pm) perl(Moose/Role.pm) perl(MooseX/ClassAttribute.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: A very simplistic workflow framework
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PR/PRAVUS/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
`Workflow::Lite' is a very simple framework for defining and
implementing workflows.  This module is actually just a wrapper
that provides helpers for implementing a workflow object.

Workflows are simply collections of steps that are able to
flow to each other as necessary.  They are implemented as
Moose objects so that attributes can be defined
to preserve stateful information between steps.  The
main functionality for workflows is implemented as a
Moose role which is installed automatically when
`use'ing `Workflow::Lite'.  This module also exports
Moose for convenience.

Steps are simply named CodeRefs that perform the actions
necessary when a workflow needs to execute a particular step.
This module provides helpers to make it easy to define
workflow steps.  Steps are purposely not implemented as
object methods to keep from cluttering up the class's
method namespace.

When a workflow object is instantiated, it's initialized to
work from the start step (the default is named 'START'). Calls
to the `work()' method will execute step handlers which may
call the `flow()' method to move to another step.  The `end()'
method is used to terminate a workflow.  Subsequent calls to
`work()' will result in an exception being thrown if a workflow
has ended.  The `is_flowing()' method can be used to check if
a workflow is still active or not.

Arguments can be passed to individual step handlers by simply
passing them to the `work()' method.  The return from a step
handler is passed through `work()' to the caller as-is.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/W*

%changelog
