# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Wrapper-GetoptLong
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: A wrapper for the Getopt::Long module
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NG/NGABRIEL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A wrapper for the Getopts::Long module.

use MyMainModule;  # has the definition for function the_date. In real practice, not a demo,
                   # MyMainModule defines all the support functions for the options.
 
use Wrapper::GetoptLong;
my $mmm=MyMainModule->new();
my %%OPTS_CONFIG=(
   'the_date'  => {
     'desc'       => q^Print today's date. Takes date_format as argument.^,
     'func'       => q^MyModule::the_date($obj->opts{'the_date'})^,
     'opt_arg_eg'   => '%%m/%%d/%%Y',
     'opt_arg_type' => 's',
     },
);

@ARGV=('--the_date', '%%m/%%d/%%Y');
my $golw_obj=new Wrapper::GetoptLong(\%%OPTS_CONFIG, $mmm);
$golw->run_getopt();
my $rc=$golw->execute_opt();
if(ref($rc))
  {
  use Data::Dumper;
  print Dumper $rc;
  }
else
  {
  print $rc, "\n";
  }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc ChangeLog README
%perl_vendor_privlib/W*

%changelog
