# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Data/Validate/URI.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(HTTP/Status.pm) perl(IO/Socket/INET.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(LWP/UserAgent.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Moose/Util/TypeConstraints.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/UseAllModules.pm) perl(URI/Split.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.07
%define module_name XCAP-Client
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: XCAP client protocol (RFC 4825).
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/T/TB/TBR/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
XCAP (RFC 4825) is a protocol on top of HTTP which allows a client to manipulate the contents of Presence Information Data Format (PIDF) based presence documents. These documents are stored in a server in XML format and are fetched, modified, replaced or deleted by the client. The protocol allows multiple clients to manipulate the data, provided that they are authorized to do so. XCAP is already used in SIMPLE-based presence systems for manipulation of presence lists and presence authorization policies.

XCAPClient library implements the XCAP protocol in client side, allowing the applications to get, store, modify and delete XML documents in the server. 

The module implements the following features:

 * Fetch, create/replace and delete a document.
 * Parameters allowing customized fields for each XCAP application.
 * Manage of multiple documents per XCAP application.
 * SSL support.
 * Exception for each HTTP error response.
 * Digest and Basic HTTP authentication.

Todo:

 * Fetch, create/replace and delete a document element (XML node)
 * Fetch, create/replace and delete an element attribute. 
 * Fetch the XCAP server auids, extensions and namespaces.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README docs
%perl_vendor_privlib/X*

%changelog
