# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp/Clan.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec/Functions.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(Test/XML/Easy.pm) perl(XML/Easy/Text.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 1.22
%define module_name XML-Easy-Transform-RationalizeNamespacePrefixes
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.22
Release: alt1
Summary: rationalize namespaces prefixes
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MA/MARKF/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This code creates a new tree of XML::Easy::Element nodes by examining
an existing XML::Easy::Element tree and producing a new tree that is
schemantically identical under the XML Namespaces 1.0 specification
but with all namespace declartions moved to the top node of the tree
(this may involve renaming several elements in the tree to have different
prefixes.)

It supplies one public function that can do this transformation which is
exported on request:

=over

=item rationalize_namespace_prefixes($easy_element)

=item rationalize_namespace_prefixes($easy_element, $generator_subref)

=item rationalize_namespace_prefixes($easy_element, $options_hashref)

The first argument is a XML::Easy::Element that you wish a transformed
copy of to be returned.  An exception will be thrown if thrown if the
XML document is not namespace-well-formed (i.e. it breaches the XML
Namespaces 1.0 specification.)

The second (optional) argument may be a reference to a function that should,
when passed a string containing a xml prefix as its first argument,
return a string containing an alternative xml prefix.  If no function is
passed in then the default renaming function is used, which will append
or replace trailing numbers with higher numbers to the prefix.

Alternativly, a hashref may be passed as the (optional) second arguement.
The keys of this hash may be:

=over

=item generator

The prefix generating subroutine reference, as previously described.

=item namespaces

A hashref containing a mapping of namespace to prefixes that you want
to force to be declared.  This enables you to control exactly what
prefixes are used for what namespaces and to force additional namespace
declarations for namespaces not otherwise mentioned in the XML
document you are transforming.  Specifying more than one namespace that
maps to the same prefix will cause an exception to be thrown.

=item force_attribute_prefix

By default attributes without a prefix have the same namespace as the
element that they belong to.  Setting this to a true value will force
prefixes to be prepended to attribute names even if they could be
ommited.

=back

The new XML::Easy::Element will be returned as the only return value
of this function.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CHANGES
%perl_vendor_privlib/X*

%changelog
