# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test.pm) perl(XML/SAX/Base.pm) perl(XML/SAX/EventMethodMaker.pm) perl(XML/SAX/Machines.pm) perl(XML/SAX/ParserFactory.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name XML-Filter-Mode
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Filter out all chunks not in the current mode.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RB/RBS/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Filters portions of documents based on a `mode=' attribute.

I use this to have XML documents that can be read in several modes, for
instance "test", "demo" and normal (ie not test or demo), or "C",
"Bytecraft_C", "Perl".

Mode names must contain only alphanumerics and "_" (ie match Perl's
\w regexp assertion).

The filter is given a comma separated list of modes.  Each element in
the XML document may have a mode="" attribute that gives a mode
expression.  If there is no mode attribute or it is empty or the mode
expression matches the list of modes, then the element is accepted.
Otherwise it and all of its children are cut from the document.

The mode expression is a boolean expression using the operators `&'
(which unfortunately must be escaped as "&amp;"),
`|', `,' to build mode matching expressions from a list
Parentheses may be used to group operations.  of words.  `,' and <|>
are synonyms.

`!' may be used as a prefix negation operator, so `!a' means "unless
mode a".

Examples:

    Modes    mode="..." Action
    Enabled  Value
    =====    ========== ======
    (none)   ""         pass

    a        ""         pass
    a        "a"        pass
    a        "a"        pass
    a,b      "a"        pass
    a        "a,b"      pass
    b        "a,b"      pass
    a,b      "a,b"      pass
    b        "!a,b"     pass
    a,b      "a b"      pass

    (none)   "b"        cut
    a        "b"        cut
    a        "a&amp;b"  cut
    b        "a&amp;b"  cut
    a        "!a,b"     cut
    a        "!a"       cut


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CHANGES
%perl_vendor_privlib/X*

%changelog
