# BEGIN SourceDeps(oneline):
BuildRequires: perl(Date/Parse.pm) perl(DateTime.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(XML/Writer.pm)
# END SourceDeps(oneline)
%define module_version 0.07
%define module_name XML-GSA
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: Creates xml in google search appliance (GSA) format
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/W/WA/WANDERER/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This is a lib that allows one to create xml in Google Search Appliance (GSA) format.

You can use this lib in the following way:

    use XML::GSA;

    my $gsa = XML::GSA->new('base_url' => 'http://foo.bar');
    my $xml = $gsa->create(
        [   {   'action'  => 'add',
                'records' => [
                    {   'url'      => '/aaa',
                        'mimetype' => 'text/plain',
                        'action'   => 'delete',
                    },
                    {   'url'      => '/bbb',
                        'mimetype' => 'text/plain',
                        'metadata' => [
                            { 'name' => 'og:title', 'content' => 'BBB' },
                        ],
                    }
                ],
            },
        ]
    );
    print $xml;

Which will output:

    <?xml version="1.0" encoding="UTF-8"?>
    <!DOCTYPE gsafeed PUBLIC "-//Google//DTD GSA Feeds//EN" "">
    <gsafeed>
        <header>
            <datasource>Source</datasource>
            <feedtype>incremental</feedtype>
        </header>
        <group action="add">
            <record action="delete" url="http://www.foo.bar/aaa" mimetype="text/plain"></record>
            <record url="http://www.foo.bar/bbb" mimetype="text/plain">
                <metadata>
                    <meta content="BBB" name="og:title"></meta>
                </metadata>
            </record>
        </group>
    </gsafeed>


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.pod
%perl_vendor_privlib/X*

%changelog
