%define module_version 0.103
%define module_name XML-LibXML-Debugging
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTML/HTML5/Entities.pm) perl(JSON.pm) perl(Test/More.pm) perl(XML/LibXML.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.103
Release: alt1
Summary: get debugging information from XML::LibXML nodes
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/XML-LibXML-Debugging

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module adds a couple of additional methods to XML::LibXML::Node
objects which are mostly aimed at helping figure out what's going on
with the DOM's namespaces and structure. `toClarkML' produces a
string of XML-like markup with explicit namespaces. The following XML:

  <foo xmlns="http://example.com/1"
       xmlns:bar="http://example.com/2"
       bar:baz="quux" />

Might be represented as:

  <{http://example.com/1}foo
       {http://www.w3.org/2000/xmlns/}xmlns="http://example.com/1"
       {http://www.w3.org/2000/xmlns/}bar="http://example.com/2"
       {http://example.com/2}baz="quux" />

Another method `toDebuggingHash' returns a hashref suitable for
dumping using Data::Dumper.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README COPYRIGHT examples
%perl_vendor_privlib/X*

%changelog
