# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(LWP/UserAgent.pm) perl(Test/More.pm) perl(XML/LibXML.pm)
# END SourceDeps(oneline)
%define module_name XML-LibXML-Proxy
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.1
Release: alt1
Summary: Force LibXML to use a proxy for HTTP/HTTPS external entities
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LI/LIS/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
Force the XML::LibXML manpage to use a proxy using the LWP::UserAgent manpage as its external
entity loader, instead of connecting directly to remote servers.  Adds HTTPS
support as a bonus.

LibXML's native HTTP client has no proxy support, and the mere parsing or
validating of an XML document risks making network requests to obtain
referenced DTDs.  This causes slow performance and unnecessary strain on
network resources and the remote server.

When dealing just with slow-changing standards, such as XHTML 1.1 Strict,
downloading the necessary DTDs locally and setting up a "catalog" for LibXML
to map known remote DTDs to local files is cumbersome but tolerable.  Some
standards however, evolve more rapidly and have large numbers of versions in
the wild, making maintaining a complete catalog near-impossible.

Forcing LibXML to request DTDs through a caching forward proxy is an elegant
solution to this problem (and is recommended by the W3 Consortium).  Short of
LibXML doing it, now the proxy can do proper caching based on HTTP response
headers.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE.txt
%perl_vendor_privlib/X*

%changelog
