%define module_name XML-Minifier
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Module/Build.pm) perl(Pod/Usage.pm) perl(Test/More.pm) perl(Test/Slow.pm) perl(XML/LibXML.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.03
Release: alt1
Summary: A configurable XML minifier.
Group: Development/Perl
License: artistic_2
URL: https://github.com/thibaultduponchelle/XML-Minifier

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CO/CONTRA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Here is the simplest way to use XML::Minifier :

    use XML::Minifier;

    my $maxi = "<person>   <name>tib   </name>   <level>  42  </level>  <city>   </city>  </person>";
    my $mini = minify($maxi);

But a typical use would include some parameters like this :

    use XML::Minifier qw(minify);

    my $maxi = "<person>   <name>tib   </name>   <level>  42  </level>  <city>   </city>  </person>";
    my $mini = minify($maxi, no_prolog => 1, aggressive => 1);

That will produce :

    <person><name>tib</name><level>42</level><city/></person>

aggressive, destructive and insane are shortcuts that define a set of parameters. 

You can set indivually with :

    use XML::Minifier qw(minify);

    my $maxi = "<person>   <name>tib   </name>   <level>  42  </level>  <city>   </city>  </person>";
    my $mini = minify($maxi, no_prolog => 1, aggressive => 1, keep_comments => 1, remove_indent => 1);

The code above means "minify this string with aggressive mode BUT keep comments and in addition remove indent".

Not every parameter has a keep_ neither a remove_, please see below for detailed list.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes
%perl_vendor_privlib/X*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
