# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(Module/Build/Tiny.pm) perl(Pod/Usage.pm) perl(Test/More.pm) perl(XML/LibXML.pm)
# END SourceDeps(oneline)
%define module_name XML-Minify
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: A configurable XML minifier.
Group: Development/Perl
License: perl
URL: https://github.com/thibaultduponchelle/XML-Minify

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CO/CONTRA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Here is the simplest way to use XML::Minify :

    use XML::Minify;

    my $maxi = "<person>   <name>tib   </name>   <level>  42  </level>  </person>";
    my $mini = minify($maxi);

But a typical use would include some parameters like this :

    use XML::Minify qw(minify);

    my $maxi = "<person>   <name>tib   </name>   <level>  42  </level>  </person>";
    my $mini = minify($maxi, no_prolog => 1, aggressive => 1);

That will produce :

    <person><name>tib</name><level>42</level></person>

aggressive, destructive and insane are shortcuts that define a set of parameters. 

You can set indivually with :

    use XML::Minify qw(minify);

    my $maxi = "<person>   <name>tib   </name>   <level>  42  </level>  </person>";
    my $mini = minify($maxi, no_prolog => 1, aggressive => 1, keep_comments => 1, remove_indent => 1);

The code above means "minify this string with aggressive mode BUT keep comments and in addition remove indent".

Not every parameter has a keep_ neither a remove_, please see below for detailed list.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/X*

%changelog
