# BEGIN SourceDeps(oneline):
BuildRequires: perl(Date/Format.pm) perl(Date/Parse.pm) perl(ExtUtils/MakeMaker.pm) perl(FileHandle.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(XML/RSS/Parser.pm) perl(XML/RSS/Parser/Util.pm) perl(Task/Weaken.pm)
# END SourceDeps(oneline)
%define module_version 1.3031
%define module_name XML-RAI
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.3031
Release: alt1
Summary: RSS Abstraction Interface.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/T/TI/TIMA/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The RSS Abstraction Interface, or RAI (said "ray"), provides an.object-oriented interface to XML::RSS::Parser trees that abstracts
the user from handling namespaces, overlapping and alternate tag
mappings.

It's rather well known that, while popular, the RSS syntax is a bit
of a mess. Anyone who has attempted to write software that consumes
RSS feeds "in the wild" can attest to the headaches in handling the
many formats and interpretations that are in use. For instance, in
"The myth of RSS compatibility"
http://diveintomark.org/archives/2004/02/04/incompatible-rss
Mark Pilgrim identifies 9 different versions of RSS (there are 10
actually[1]) and that is not without going into tags with
overlapping purposes. Even the acronym RSS has multiple though
similar meanings.

The the XML::RSS::Parser manpage alone attempts to help developers cope with these
issues through a liberal interpretation of what is RSS and routines
to normalize the parse tree into a more common and manageable form.

RAI takes this one step further. Its intent is to give a developer
the means to not have to care about what tags the feed uses to
present its meta data.

RAI provides a single simplified interface that maps one method
call to various overlapping and alternate tags used in RSS feeds.
The interface also abstracts developers from needing to deal with
namespaces. Method names are based on Dublin Core terminology.

With the release of version 1.0, the the XML::RSS::Parser manpage 
distribution was folded into XML::RAI. 

[1] When initially released, RSS 2.0 had a namespace. When it was
reported a few days later that some XSLT-based systems were
breaking because of the change in the RSS namespace from "" (none)
to http://backend.userland.com/rss2, the namespace was removed, but
the version number was not incremented making it incompatible with
itself. http://groups.yahoo.com/group/rss-dev/message/4113 This
version was not counted in Mark's post.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/X*

%changelog
