Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-XML-Simple-DTDReader
Version:        0.04
Release:        alt2_48
Summary:        Simple XML file reading based on their DTDs
# Automatically converted from old format: GPL+ or Artistic - review is highly recommended.
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/XML-Simple-DTDReader
Source0:        https://cpan.metacpan.org/modules/by-module/XML/XML-Simple-DTDReader-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(XML/Parser.pm)
# Tests
BuildRequires:  perl(Test/More.pm)
Requires:       perl(XML/Parser.pm) >= 2.280

# Filter under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(XML.Parser.pm)/d

%description
XML::Simple::DTDReader aims to be a XML::Simple drop-in replacement, but
with several aspects of the module controlled by the XML's DTD.
Specifically, array folding and array forcing are inferred from the DTD.

%prep
%setup -q -n XML-Simple-DTDReader-%{version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install

make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT

find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null \;
# strange perls in '#!'
fix_shabang_in_perl()
{
	local f="$1"
	#!/usr/bin/perl -w -- -*- mode: cperl -*-
	sed -i -e '1s,^#\![[:space:]]*\(/usr\)\?/bin/env[[:space:]]*perl,#!/usr/bin/perl,;1s,-\*-[[:space:]]*cperl[[:space:]]*-\*-,,;1s,-\*-[[:space:]]*[Mm]ode:[[:space:]]*[Cc]?[pP]erl[[:space:]]*-\*-,,' $f 
	sed -i -e '1s,^#\!/usr/local/bin/perl,#!/usr/bin/perl,' $f 
}
for dir in %buildroot%_bindir %buildroot%perl_vendor_archlib %buildroot%perl_vendor_privlib ; do
    if [ -d $dir ]; then
    	find $dir -type f -executable | while read f; do
	  case `file $f` in
	    *perl*) fix_shabang_in_perl $f 
	    ;;
	  esac
	done
	find $dir -type f \( -name '*.pm' -or -name '*.pl' \) | while read f; do
	  fix_shabang_in_perl $f
	done
    fi
done


# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
