Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Encode.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-XML-Smart
Version:        1.79
Release:        alt2_35
Summary:        Smart, easy and powerful way to access/create XML files/data
# Automatically converted from old format: GPL+ or Artistic - review is highly recommended.
License:        GPL-1.0-or-later OR Artistic-1.0-Perl

URL:            https://metacpan.org/release/XML-Smart
Source0:        https://cpan.metacpan.org/authors/id/T/TM/TMHARISH/XML-Smart-%{version}.tar.gz

BuildArch:      noarch
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(Carp.pm)
# Data::Dumper not used at tests
# Devel::Cycle not used at tests
# Encode not used with current Perl
BuildRequires:  perl(Exporter.pm)
# LWP not used at tests
# LWP::UserAgent not used at tests
BuildRequires:  perl(Object/MultiType.pm)
BuildRequires:  perl(vars.pm)
# Tests:
BuildRequires:  perl(open.pm)
BuildRequires:  perl(Test.pm)
BuildRequires:  perl(Test/More.pm)
# Optional tests:
BuildRequires:  perl(Devel/Cycle.pm)
BuildRequires:  perl(LWP/UserAgent.pm)
BuildRequires:  perl(Test/Pod.pm)
# Test::Pod::Coverage 1.08 not used
Requires:       perl(Data/Dumper.pm)
Requires:       perl(Devel/Cycle.pm)
Requires:       perl(LWP.pm)
Requires:       perl(LWP/UserAgent.pm)
Requires:       perl(Object/MultiType.pm) >= 0.030


# Remove under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(Object.MultiType.pm)/d

%description
This module provides an easy way to access/create XML data. It's based on a
HASH tree created from the XML data, and enables dynamic access to it
through the standard Perl syntax for Hash and Array, without necessarily
caring about which you are working with. In other words, each point in the
tree works as a Hash and an Array at the same time!

%prep
%setup -q -n XML-Smart-%{version}


%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build


%install
make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT
# %{_fixperms} $RPM_BUILD_ROOT/*


%check
make test


%files
%doc Changes README
%{perl_vendor_privlib}/XML*


%changelog
