%define module_name XML-XPathScript
# BEGIN SourceDeps(oneline):
BuildRequires: perl(B/XPath.pm) perl(Carp.pm) perl(Clone.pm) perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Spec.pm) perl(IO/File.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Readonly.pm) perl(Scalar/Util.pm) perl(Symbol.pm) perl(Test.pm) perl(Test/More.pm) perl(Unicode/CharName.pm) perl(XML/LibXML.pm) perl(XML/Parser.pm) perl(XML/XPath.pm) perl(XML/XPath/Node.pm) perl(XML/XPath/NodeSet.pm) perl(XML/XPath/XMLParser.pm) perl(base.pm) perl(bytes.pm) perl(constant.pm) perl(overload.pm) perl(strict.pm) perl(utf8.pm) perl(vars.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.00
Release: alt1
Summary: a Perl framework for XML stylesheets
Group: Development/Perl
License: perl
URL: https://github.com/yanick/xml-xpathscript

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/Y/YA/YANICK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
XPathScript is a stylesheet language similar in many ways to XSLT (in
concept, not in appearance), for transforming XML from one format to
another (possibly HTML, but XPathScript also shines for non-XML-like
output).

Like XSLT, XPathScript offers a dialect to mix verbatim portions of
documents and code. Also like XSLT, it leverages the powerful
``templates/apply-templates'' and ``cascading stylesheets'' design
patterns, that greatly simplify the design of stylesheets for
programmers. The availability of the *XPath* query language inside
stylesheets promotes the use of a purely document-dependent,
side-effect-free coding style. But unlike XSLT which uses its own
dedicated control language with an XML-compliant syntax, XPathScript
uses Perl which is terse and highly extendable.

The result of the merge is an extremely powerful tool for rendering
complex XML documents into other formats. Stylesheets written in
XPathScript are very easy to create, extend and reuse, even if they
manage hundreds of different XML tags.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build --install_path bindoc=%_man1dir

%install
%perl_vendor_install

%files
%doc README.mkdn CODE_OF_CONDUCT.md CONTRIBUTORS Changes LICENSE README examples manual
%perl_vendor_privlib/X*

%changelog
