# BEGIN SourceDeps(oneline):
BuildRequires: perl(Device/SerialPort.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Socket/INET.pm) perl(Test.pm) perl(Audio/DSP.pm) perl(Audio/Wav.pm)
# END SourceDeps(oneline)
%define module_version 1.02
%define module_name Xmpcr
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.02
Release: alt1
Summary: control an XMPCR device for XM Radio
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PA/PAULB/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The Audio::Xmpcr module allows you to control an XMPCR device,
which is used to tune into the XM satellite radio network.
More info can be found at http://www.xmradio.com. The device
itself can only be purchased (as of this writing) at PCConnection
http://www.pcconnection.com.

The api operates in one of two modes. First, a direct SERIAL
mode where the api communicates with the device directly. This is usually
not desirable because polling the device for song data is time consuming.
Time required to pull an entire channel/song/artist listing is upwards
of 10-20 seconds. Also, the device may be shared by several users/programs.
Protocol confusion may result if everyone is talking at the same time.
Note that the serial mode will write a channel cache file into 
~/.xmpcrd-cache, so if the channel list changes, you'll need to delete
this file and restart the program. (i.e., since the daemon uses serial
mode, you'll need to restart the daemon)

The second mode of operation is NETWORK/DAEMON mode. Here, a daemon
runs on the machine connected to the Pcr, and all communication with the
daemon is done via sockets. This is preferable for most applications, as
the daemon takes care of much of the busy work. In particular, the
daemon continuously polls the device, and updates its internal channel
listing. The default timing allows 4 channels to be updated each second.
Also, every half second, the current channel is updated - since we always
want to know when the channel data changes on the current channel. This
means that it takes 100/4 or 25 seconds to refresh all channels. When
retrieving a channel/song listing, a few channels may be out of date, 
but will most certainly be correct the next pass through.  See the note
about the cache file in the SERIAL mode paragraph, above.

The mode is chosen when the device is instantiated - i.e., the constructor
is an abstract factory for the two types of connections. Regardless of the 
mode chosen, the interface supports the same method calls and behaviour 
with few exceptions. That is, you won't care whether you're talking 
directly to the device or the daemon - the api will return the same 
results either way. The following is a list of exceptions to that rule:

=over 1

=item list()

Via daemon, this call returns almost immediately; via SERIAL, dramatically slower (i.e., a full channel pull will take between 10-20 secs)

=item events() and processEvents()

Channel events are not supported in the SERIAL api.

=back 1

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/A*

%files scripts
%_bindir/*

%changelog
