# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/dot perl(ExtUtils/MakeMaker.pm) perl(Hash/PriorityQueue.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Text/CSV.pm) perl(autodie.pm) perl(experimentals.pm) perl(version.pm)
# END SourceDeps(oneline)
%define module_name YAGL
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1
Release: alt1
Summary: Yet Another Graph Library
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RL/RLOVELAND/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This library implements a
graph
data structure, and a number of common algorithms on graphs.  It can
be used for both directed and undirected graphs.  Features include:

=over

=item * Generating random graphs.

=item * Serializing graphs to and from CSV files.

=item * Vertices and edges can have arbitrary attributes associated
with them (stored in hashrefs).

=item * Breadth-first search (BFS) to find the shortest path between
two nodes.

=item * Depth-first search (DFS).

=item * Find minimum spanning trees of weighted graphs.

=item * List the connected components.

=item * Dijkstra's algorithm for finding the shortest path through a
weighted graph.

=item * A general method for exhaustive search with backtracking.

=item * Finding Hamiltonian walks (open and closed) using exhaustive
search with backtracking.

=item * Vertex coloring.

=back

For a possibly interesting example, see the file
`examples/ladders.pl', which is an approximate port to Perl of the
`LADDERS' program from the book *The Stanford GraphBase* by Donald
E. Knuth.  It uses Dijkstra's algorithm to build a "word ladder" of
the form:

WORDS - WOODS - GOODS - GOADS - GRADS - GRADE - GRAPE - GRAPH

Finally, note that this library is still in development.  There are
some important algorithms that are not yet implemented.  Also, some
algorithms that are implemented for undirected graphs are not yet
implemented for directed graphs.  Test coverage is OK, but can still
be improved.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc todo.org_archive todo.org README.build Changes README examples
%perl_vendor_privlib/Y*

%changelog
