# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON.pm) perl(JSON/Parse.pm) perl(LWP/UserAgent.pm) perl(Test/More.pm) perl(URL/Builder.pm) perl(XML/LibXML.pm) perl(XML/Validate.pm)
# END SourceDeps(oneline)
%define module_name Yahoo-Weather-Api
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.00
Release: alt1
Summary: The great new 2018 Yahoo::Weather::Api
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SP/SPAJAI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Yahoo::Weather::Api fetches the Weather information as provided by the Yahoo's weather API.

Access is limited to 2,000 signed calls per day

Refer more here https://developer.yahoo.com/weather/

    #using place name
    use Yahoo::Weather::Api;
    my $api = Yahoo::Weather::Api->new();
    print  $api->get_weather_data({ 'search' => 'Palo Alto, CA, US' });

                                or

    #using cordinate
    use Yahoo::Weather::Api;
    my $api = Yahoo::Weather::Api->new({ 'unit' => 'F', 'format' => 'xml' , internet_check => 1});
    print  $api->get_weather_data_by_geo({'long' => '74.932999', 'lat' => '31.7276', 'only'=>1}); 

                                or

    #using zip
    use Yahoo::Weather::Api;
    my $api = Yahoo::Weather::Api->new({ 'unit' => 'C', 'format' => 'xml'});
    print  $api->get_weather_data_by_geo({ 'search' => '32003' });  #zip

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/Y*

%changelog
