%define module_name ZMQ
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Sub/Name.pm) perl(Test/Fatal.pm) perl(YAML/Tiny.pm) perl(ZMQ/Constants.pm) perl(bytes.pm) perl(threads.pm) perl(ZMQ/LibZMQ3.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.06
Release: alt1
Summary: Perl-ish Interface libzmq 
Group: Development/Perl
License: perl
URL: https://github.com/lestrrat/p5-ZMQ

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DM/DMAKI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
ZMQ is a Perl-ish wrapper for libzmq. It uses ZMQ::LibZMQ2 or ZMQ::LibZMQ3 (ZMQ::LibZMQ2 is the default) as the actual backend.

If you want a one-to-one direct mapping to libzmq, then you should be using ZMQ::LibZMQ2 or ZMQ::LibZMQ3 directly

ZMQ will automatically choose the backend (either ZMQ::LibZMQ2 or ZMQ::LibZMQ3) to use. This can be explicitly specified by setting `PERL_ZMQ_BACKEND' environment variable.

By default ZMQ::LibZMQ2 will be used as the backend. This may change in future
versions, so make sure to explicitly set your backend if you don't want it to
change:

    BEGIN {
        $ENV{ PERL_ZMQ_BACKEND } = 'ZMQ::LibZMQ2';
    }
    use ZMQ;

If you think your code will be used from another program that also uses libzmq,
you might want to consider using the ZMQ::LibZMQ* modules. This is because you
can't write "truly" portable code using this high level interface (libzmq's
API change rather drastically between versions). Personally, I'd recommend
only using this module for your one-shot scripts, and use ZMQ::LibZMQ* for
all other uses. YMMV.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/Z*

%changelog
