# BEGIN SourceDeps(oneline):
BuildRequires: perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Log/Any.pm) perl(Module/Build.pm) perl(Module/Load.pm) perl(Module/Loaded.pm) perl(Moo.pm) perl(Params/Validate.pm) perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(URI.pm) perl(autodie.pm)
# END SourceDeps(oneline)
%define module_name Zabbix7-API
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.1
Release: alt1
Summary: Access the JSON-RPC API of a Zabbix server
Group: Development/Perl
License: see LICENSE
URL: https://github.com/scotticles/perl-zabbix7-api

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SC/SCOTTH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is a Moo wrapper around the Zabbix 7.x JSON-RPC API.

For the Zabbix 1.8.x series, see the Zabbix::API manpage.
For the Zabbix < 6.0 series, see the Zabbix2::API manpage.

What you need to start hacking is probably the `fetch' method in
`Zabbix7::API'; be sure to check out also what the various
`Zabbix7::API::Foo' classes do, as this is how you'll be manipulating
the objects you have just fetched.

Not all the tests have been tested for version 7, my focus on this library is making the hosts work for pulling information. I do not use the api to create objects or alter.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE CHANGES
%perl_vendor_privlib/Z*

%changelog
