%define module_version 0.05
%define module_name autobox-Closure-Attributes
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(PadWalker.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/Exception.pm) perl(YAML/Tiny.pm) perl(autobox.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: closures are objects are closures
Group: Development/Perl
License: perl
URL: https://github.com/sartak/autobox-Closure-Attributes/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SA/SARTAK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module uses powerful tools to give your closures accessors for each of the
closed-over variables. You can get *and* set them.

You can get and set arrays and hashes too, though it's a little more annoying:

    my $code = do {
        my ($scalar, @array, %%hash);
        sub { return ($scalar, @array, %%hash) }
    };

    $code->scalar # works as normal

    my $array_method = '@array';
    $code->$array_method(1, 2, 3); # set @array to (1, 2, 3)
    $code->$array_method; # [1, 2, 3]

    my $hash_method = '%%hash';
    $code->$hash_method(foo => 1, bar => 2); # set %%hash to (foo => 1, bar => 2)
    $code->$hash_method; # { foo => 1, bar => 2 }

If you're feeling particularly obtuse, you could do these more concisely:

    $code->${\ '%%hash' }(foo => 1, bar => 2);
    $code->${\ '@array' }

I recommend instead keeping your hashes and arrays in scalar variables if
possible.

The effect of the autobox manpage is lexical, so you can localize the nastiness to a
particular section of code -- these mysterious closu-jects will revert to their
inert state after the autobox manpage's scope ends.


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/a*

%changelog
