# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/NoWarnings.pm) perl(Test/Pod/Coverage.pm) perl(YAML/Tiny.pm) perl(constant.pm) perl(ex/lib.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name constant-def
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Perl pragma to declare previously undeclared constants
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MO/MONS/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Define compile-time constant only if it wasn't previously defined elsewhere.
The main reason is to use for debugging constants, since there is no way to change the value, except by editing the source

    # common way: (redefine may be done only in source file)
    use constant DEBUG => ...;
    # or 
    BEGIN { *DEBUG = sub () { ... } }
    # or 
    sub DEBUG () { ... }

    ################

    # complex way: redefine works, if done before use of module
    # in main.pl
    BEGIN { *My::Module::Debug = sub () { 1 }; }
    use My::Module;

    # in My/Module.pm
    BEGIN { defined &DEBUG or do { my $debug = $ENV{MY_MODULE_DEBUG} || 0; *DEBUG = sub () { $debug } } }

    ################

    # using this distribution
    # redefine works, if done before use of module

    # in main.pl
    use constant::abs 'My::Module::DEBUG' => 1;
    use My::Module;

    # in My/Module.pm
    use constant::def DEBUG => $ENV{MY_MODULE_DEBUG} || 0;
    
Syntax is fully compatible with `constant'


%prep
%setup -n %module_name-%module_version
rm -f t/[0-9]-kwalitee.t t/[0-9][0-9]-kwalitee.t t/[0-9]kwalitee.t t/[0-9][0-9]kwalitee.t

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/c*

%changelog
