%define module_name custom-failures-x-alias
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Module/Build/Tiny.pm) perl(Test/CleanNamespaces.pm) perl(Test/Lib.pm) perl(Test/More.pm) perl(Test2/V0.pm) perl(custom/failures.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: export aliases for custom::failures
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DJ/DJERIUS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This package creates importable alias subroutines for failure classes created by the custom::failures manpage.

Typically, you use the custom::failures manpage like this:

  package MyApp::failure;
  use custom::failures qw/io::flie io::network/;

and later

  package MyApp;
  use MyApp::failure;

  # somewhere deep in your code
  MyApp::failure::io::flie->throw();

the custom::failures::x::alias entry elsewhere in this document creates shortened aliases so that you don't have to type so much:

  package MyApp::failure;
  use custom::failures::x::alias qw/io::flie io::network/;

and later,

  package MyApp;
  use MyApp::failure ':all'

  # somewhere deep in your code
  io_flie->throw;
  io_network->throw;

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md.orig Changes README CONTRIBUTING.md
%perl_vendor_privlib/c*

%changelog
