# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name	 data-trie
%define upstream_version 0.01

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_11

Summary:	An implementation of a letter trie
License:	GPL
Group:		Development/Perl
Url:		https://metacpan.org/release/%{upstream_name}
Source0:	https://cpan.metacpan.org/authors/id/H/HA/HAMMOND/%{upstream_name}-%{upstream_version}.tar.bz2

BuildArch:	noarch
Source44: import.info

%description
This module implements a letter trie data structure. This is a linked set of
nodes representing a set of words. Starting from the root, each letter of an
included word is a daughter node of the trie. Hence, if a word is in the trie,
there will be a path from root to leaf for that word. If a word is not in the
trie, there will be no such path.

This structure allows for a relatively compact representation of a set of
words. This particular implementation allows each word to be stored alone or
with some associated data item.

Note that the remove() method does not prune nodes and thus a Trie can only
grow in size.

%prep
%setup -q -n Data-Trie-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
%{__make} test

%install
%makeinstall_std

%files
%doc README
%{perl_vendor_privlib}/Data




%changelog
