%define module_name exact-lib
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(FindBin.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/EOL.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Portability/Files.pm) perl(Test/Synopsis.pm) perl(Test2/V0.pm) perl(XS/Parse/Keyword.pm) perl(exact.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.05
Release: alt1
Summary: Compile-time @INC manipulation extension for exact
Group: Development/Perl
License: artistic_2
URL: https://github.com/gryphonshafer/exact-lib

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GR/GRYPHON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the exact::lib manpage is an extension for the exact manpage that provides a means to easily
manipulate @INC at compile time. When called, it will look for what appears to
be space-separated list of paths. If such a list is not provided, it will assume
"lib" as the default value.

    use exact -lib;       # same as below
    use exact 'lib(lib)'; # same as above

For each path that is a relative path that does not begin with ".", a relative
path will be searched for at or above the directory of the program (`$0'). If
found, that path will be added; if not found, nothing happens.

    use exact -lib;
    # will look for "lib" in program's directory first,
    # then if not found will look in the parent directory,
    # then if still not found, the parent's parent, and so on...

For any path in the list, if that item is an absolute path, that absolute path
will be directly added to the beginning of `@INC'.

    use exact 'lib( /var/something /var/something_else )';

For relative paths that begin with ".", these paths will be added to the
beginning of `@INC' as absolute paths relative to the program (`$0').

    # add "../lib" relative to $0 dir to @INC
    use exact 'lib(../lib)';

If a path contains spaces, you can escape them with a backslash:

    # example of a path that includes with spaces
    use exact 'lib( /an/absolute/path\ with\ spaces/in/it )';

See the the exact manpage documentation for additional information about
extensions. The intended use of the exact::lib manpage is via the extension interface
of the exact manpage.

    use exact -lib, -conf, -noutf8;

However, you can also use it directly, which will also use the exact manpage with
default options:

    use exact::lib;

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes SECURITY.md README
%perl_vendor_privlib/e*

%changelog
