Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Run extra test
%if ! (0%{?rhel})
%bcond_without perl_indirect_enables_extra_test
%else
%bcond_with perl_indirect_enables_extra_test
%endif

Name:           perl-indirect
Version:        0.39
Release:        alt5_28
Summary:        Lexically warn about using the indirect object syntax
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/indirect
Source0:        https://cpan.metacpan.org/authors/id/V/VP/VPIT/indirect-%{version}.tar.gz
# Module Build
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Module Runtime
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(XSLoader.pm)
# Test Suite
BuildRequires:  perl(B.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(POSIX.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(threads.pm)
BuildRequires:  perl(threads/shared.pm)
# Optional Tests
%if 0%{!?perl_bootstrap:1} && %{with perl_indirect_enables_extra_test}
BuildRequires:  perl(Devel/CallParser.pm)
BuildRequires:  perl(Devel/Declare.pm)
%endif
BuildRequires:  perl(IO/Handle.pm)
BuildRequires:  perl(IO/Select.pm)
BuildRequires:  perl(IPC/Open3.pm)
BuildRequires:  perl(Socket.pm)
# Runtime
Requires:       perl(Carp.pm)
Requires:       perl(XSLoader.pm)

# Avoid provides for perl shared objects

Source44: import.info

%description
When enabled (or disabled as some may prefer to say, since you actually
turn it on by calling no indirect), this pragma warns about indirect object
syntax constructs that may have slipped into your code.

%prep
%setup -q -n indirect-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="%{optflags}"
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -delete
find %{buildroot} -type f -name '*.bs' -empty -delete
# %{_fixperms} -c %{buildroot}

%check
make test

%files
%doc Changes README samples/
%{perl_vendor_archlib}/auto/indirect/
%{perl_vendor_archlib}/indirect.pm

%changelog
