%define module_name lib-prereqs-only
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(lib/filter.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004
Release: alt1
Summary: Only allow modules specified in prereqs in dist.ini to be locateable/loadable
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/lib-prereqs-only

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This pragma reads the prerequisites found in dist.ini, the modules found in
lib/, and uses the lib::filter manpage to only allow those modules to be
locateable/loadable. It is useful while testing the Dist::Zilla manpage-based
distribution: it tests that the prerequisites you specify in dist.ini is
already complete (at least to run the test suite).

Some caveats:

=over

=item * This pragma currently only works via `PERL5OPT'

Using:

 %% prove -Mlib::prereqs::only ...

currently does not work.

=back

By default, only prereqs specified in RuntimeRequires and TestRequires sections
are allowed. But you can include other sections too if you want:

 %% PERL5OPT=-Mlib::prereqs::only=RuntimeRecommends,1,TestSuggests,1 prove ...

Currently only (Runtime|Test)(Requires|Recommends|Suggests) are recognized.

Other options that can be passed to the pragma:

=over

=item * allow_core => bool (default: 1)

This will be passed to lib::filter. By default (allow_core=1), core modules will
also be allowed. If you specify core modules in your prereqs and want to test
that, perhaps you want to set this to 0 (but currently XS modules won't work
with `allow_core' set to 0).

=item * debug => bool (default: 0)

If set to 1, will print debug messages.

=item * allow => str

Specify an extra set of modules to allow. Value is a semicolon-separated list of
module names. Will be passed to lib::filter.

=item * disallow => str

Specify an extra set of modules to disallow. Value is a semicolon-separated list
of module names. Will be passed to lib::filter.

=item * allow_re => str

Specify module pattern to allow. Will be passed to lib::filter.

=item * disallow_re => str

Specify module pattern to disallow. Will be passed to lib::filter.

=back

=for Pod::Coverage .+
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/l*

%changelog
