%define module_name lib-root
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Cwd.pm) perl(Module/Build/Tiny.pm) perl(Path/Tiny.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: find perl root and push lib modules path to @INC
Group: Development/Perl
License: perl
URL: https://github.com/hernan604/lib-root

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HE/HERNAN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
lib::root looks for a .libroot file on parent directories and pushes ./*/lib to @INC.

When a file does `use lib::root', lib::root will try to read the file parent directories and look for a rootfile (default is .libroot) that is usually located inside a /some/dir/perl that contains many modules used by your app. Many apps have a /some/dir/perl/.perl-version file inside a perl directory, when that is the case, the app can piggy back on that filename and look for that file instead of .libroot with the example below:

  use lib::root rootfile => '.perl-version';

To use the defaults, create an empty file named .libroot and place it in your /app/dir/perl/.libroot

  use lib::root;

  ... or use another custom file to determine a libroot

  use lib::root; # rootfile defaults to .libroot
  use lib::root rootfile => '.perl-version';

  ... or add a callback if needed

  use lib::root callback => sub { ... };

  ... or look for a given file in approot and use a perl root dir to push to inc

  use lib::root rootfile => '.app-root', perldir => 'perl';

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/l*

%changelog
