# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Sub/Util.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define module_name methods-import
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: import methods to be used like keywords
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/methods-import

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
methods::import simplifies the task of calling a lot of methods on a single
object.

Instead of:

  $thing->set_foo(1);
  $thing->process();
  $thing->set_foo(2);
  $thing->set_bar(3);
  $thing->process;

You can write:

 for ($thing) {
   use methods::import qw( set_foo set_bar process );
   
   set_foo 1;
   process;
   set_foo 2;
   set_bar 3;
   process;
 }
 
 # You cannot call process() here because it was lexical

As well as `set_foo' and the other functions explicitly named in the
import list, methods::import will always export a function called
`using'.

`using' can be used as an alternative to setting `$_' to point
to an object.

 use methods::import qw( set_foo set_bar process );
 
 using $thing, sub {
   set_foo 1;
   process;
   set_foo 2;
   set_bar 3;
   process;
 };

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CREDITS Changes README COPYRIGHT LICENSE
%perl_vendor_privlib/m*

%changelog
