# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/SmokeBox/PerlVersion.pm) perl(Config.pm) perl(Config/Tiny.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(HTTP/Date.pm) perl(HTTP/Response.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Module/Load.pm) perl(Module/Pluggable.pm) perl(POE.pm) perl(POE/Component/Client/DNS.pm) perl(POE/Component/SmokeBox.pm) perl(POE/Component/SmokeBox/Dists.pm) perl(POE/Component/SmokeBox/Recent.pm) perl(POE/Filter/HTTP/Parser.pm) perl(POE/XS/Loop/EPoll.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Usage.pm) perl(Test/More.pm) perl(Test/POE/Server/TCP.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Time/Duration.pm) perl(YAML/XS.pm) perl(unless.pm)
# END SourceDeps(oneline)
%def_without test
%define module_name minismokebox
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.68
Release: alt1
Summary: a small lightweight SmokeBox
Group: Development/Perl
License: perl
URL: https://github.com/bingos/minismokebox

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BI/BINGOS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`minismokebox' is a lightweight version of SmokeBox that performs CPAN testing on a single
`perl' installation.

It is usually installed into a separate `perl' installation than the `perl' which is being
tested, the system `perl' for instance.

   /usr/bin/minismokebox --perl /home/cpan/sandbox/perl-5.10.0/bin/perl

The above command will run `minismokebox' which will obtain a list of recently uploaded distributions
to CPAN and then proceed to `smoke' each of these distributions against the indicated `perl'.

`minismokebox' supports a number of different CPAN Tester frameworks ( in the POE::Component::SmokeBox manpage
parlance a `backend' ), currently, the CPANPLUS::YACSmoke manpage, the CPAN::Reporter manpage and the CPAN::YACSmoke manpage.

   /usr/bin/minismokebox --perl /home/cpan/sandbox/perl-5.10.0/bin/perl # uses default 'CPANPLUS::YACSmoke'

   /usr/bin/minismokebox --perl /home/cpan/sandbox/perl-5.10.0/bin/perl --backend CPAN::Reporter

   /usr/bin/minismokebox --perl /home/cpan/sandbox/perl-5.10.0/bin/perl --backend CPAN::YACSmoke

`minismokebox' will `check' that the selected backend exists in the indicated `perl' before proceeding
with the `smoke' phase. This is very simple check and does not test whether the smoke environment is
properly configured to send test reports, etc. Consult the applicable documentation for instructions on
how to configure the testing environment. ( See the links below in the section on "SEE ALSO" ).

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE Changes.old examples
%perl_vendor_privlib/A*
%perl_vendor_privlib/m*
%perl_vendor_privlib/P*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
