# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Moo.pm) perl(Moose.pm) perl(Mouse.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    namespace-sweep
%define upstream_version 0.006

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_11

Summary:    Sweep up imported subs in your classes
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/namespace/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(B/Hooks/EndOfScope.pm)
BuildRequires: perl(Carp.pm)
BuildRequires: perl(Data/Dumper.pm)
BuildRequires: perl(List/Util.pm)
BuildRequires: perl(Package/Stash.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Sub/Identify.pm)
BuildRequires: perl(Sub/Name.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(overload.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch: noarch

Provides: perl(namespace/sweep.pm)
Source44: import.info

%description
Because Perl methods are just regular subroutines, it's difficult to tell
what's a method and what's just an imported function. As a result, imported
functions can be called as methods on your objects. This pragma will delete
imported functions from your class's symbol table, thereby ensuring that
your interface is as you specified it. However, code inside your module
will still be able to use the imported functions without any problems.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc README LICENSE META.yml META.json
%perl_vendor_privlib/*




%changelog
