Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-opts
Summary:        Simple command line option parser
%global upstream_version 0.08
Version:        0.080
Release:        alt1_4
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
Source0:        https://cpan.metacpan.org/authors/id/M/MI/MIKIHOSHI/opts-%{upstream_version}.tar.gz
URL:            https://metacpan.org/release/opts
BuildArch:      noarch

BuildRequires:  coreutils
BuildRequires:  perl
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Module/Build/Tiny.pm)
BuildRequires:  perl(strict.pm)
# Run-time:
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(Getopt/Long.pm)
BuildRequires:  perl(PadWalker.pm)
BuildRequires:  perl(Text/Table.pm)
BuildRequires:  perl(warnings.pm)
# Tests:
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/More.pm)
# note versioning...
Requires:       perl(Getopt/Long.pm) >= 2.370
Requires:       perl(PadWalker.pm) >= 1.900
Requires:       perl(Text/Table.pm)


# Remove under-specified dependencies

%{?perl_default_subpackage_tests}
Source44: import.info
%filter_from_requires /^perl(\(Getopt.Long\|PadWalker\).pm)/d

%description
opts is a DSL for quickly and easily handling command line options.

%prep
%setup -q -n opts-%{upstream_version}


%build
perl Build.PL --installdirs=vendor
./Build

%install
./Build install --destdir=%{buildroot} --create_packlist=0
# %{_fixperms} %{buildroot}/*

%check
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
./Build test

%files
%doc Changes README.md
%{perl_vendor_privlib}/opts.pm

%changelog
