%set_perl_req_method relaxed
Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
%filter_from_requires s,perl.Object.ID.pm..*,perl(Object/ID.pm),
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		perl-perl5i
Summary:	Fix as much of Perl 5 as possible in one pragma
Version:	2.13.2
Release:	alt2_10
License:	GPL+ or Artistic
URL:		https://metacpan.org/release/perl5i
Source0:	http://cpan.metacpan.org/authors/id/M/MS/MSCHWERN/perl5i-v%{version}.tar.gz
Patch0:		perl5i-v2.13.2-coercion.patch
# Module Build
BuildRequires:	coreutils
BuildRequires:	gcc
BuildRequires:	perl-devel
BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel >= 5.10.0
BuildRequires:	perl(lib.pm)
BuildRequires:	perl(Module/Build.pm)
# Module Runtime
BuildRequires:	perl
BuildRequires:	perl(CLASS.pm)
BuildRequires:	perl(Capture/Tiny.pm)
BuildRequires:	perl(Carp.pm)
BuildRequires:	perl(Carp/Fix/1_25.pm)
BuildRequires:	perl(Child.pm)
BuildRequires:	perl(Data/Dumper.pm)
BuildRequires:	perl(DateTime.pm)
BuildRequires:	perl(DateTime/Format/Epoch.pm)
BuildRequires:	perl(DateTime/TimeZone/Tzfile.pm)
BuildRequires:	perl(Devel/Declare/MethodInstaller/Simple.pm)
BuildRequires:	perl(Digest/MD5.pm)
BuildRequires:	perl(Digest/SHA.pm)
BuildRequires:	perl(Encode.pm)
BuildRequires:	perl(File/chdir.pm)
BuildRequires:	perl(File/Spec.pm)
BuildRequires:	perl(Hash/FieldHash.pm)
BuildRequires:	perl(Hash/Merge/Simple.pm)
BuildRequires:	perl(Hash/StoredIterator.pm)
BuildRequires:	perl(Import/Into.pm)
BuildRequires:	perl(IO/Handle.pm)
BuildRequires:	perl(IPC/System/Simple.pm)
BuildRequires:	perl(JSON/MaybeXS.pm)
BuildRequires:	perl(List/MoreUtils.pm)
BuildRequires:	perl(Modern/Perl.pm)
BuildRequires:	perl(Module/Load.pm)
BuildRequires:	perl(Object/ID.pm)
BuildRequires:	perl(Path/Tiny.pm)
BuildRequires:	perl(Perl6/Caller.pm)
BuildRequires:	perl(POSIX.pm)
BuildRequires:	perl(Scalar/Util.pm)
BuildRequires:	perl(Sub/Name.pm)
BuildRequires:	perl(Taint/Util.pm)
BuildRequires:	perl(Text/Wrap.pm)
BuildRequires:	perl(Time/y2038.pm)
BuildRequires:	perl(Try/Tiny.pm)
BuildRequires:	perl(Want.pm)
BuildRequires:	perl(YAML/Any.pm)
BuildRequires:	perl(autobox.pm)
BuildRequires:	perl(autobox/Core.pm)
BuildRequires:	perl(autobox/List/Util.pm)
BuildRequires:	perl(autobox/dump.pm)
BuildRequires:	perl(autodie.pm)
BuildRequires:	perl(autovivification.pm)
BuildRequires:	perl(base.pm)
BuildRequires:	perl(constant.pm)
BuildRequires:	perl(if.pm)
BuildRequires:	perl(indirect.pm)
BuildRequires:	perl(mro.pm)
BuildRequires:	perl(open.pm)
BuildRequires:	perl(overload.pm)
BuildRequires:	perl(parent.pm)
BuildRequires:	perl(true/VERSION.pm)
BuildRequires:	perl(utf8/all.pm)
BuildRequires:	perl(version.pm)
# Test Suite
BuildRequires:	perl(Config.pm)
BuildRequires:	perl(Exporter.pm)
BuildRequires:	perl(ExtUtils/CBuilder.pm)
BuildRequires:	perl(File/Temp.pm)
BuildRequires:	perl(IPC/Open3.pm)
BuildRequires:	perl(PerlIO.pm)
BuildRequires:	perl(Test/More.pm)
BuildRequires:	perl(Test/Most.pm)
BuildRequires:	perl(Test/Output.pm)
BuildRequires:	perl(Test/Warn.pm)
# Runtime
Requires:	perl(CLASS.pm) >= 1.0
Requires:	perl(Capture/Tiny.pm) >= 0.060
Requires:	perl(Carp/Fix/1_25.pm) >= 1.0
Requires:	perl(Child.pm) >= 0.009
Requires:	perl(Data/Dumper.pm)
Requires:	perl(DateTime.pm) >= 0.470
Requires:	perl(DateTime/Format/Epoch.pm) >= 0.110
Requires:	perl(DateTime/TimeZone/Tzfile.pm) >= 0.002
Requires:	perl(Devel/Declare/MethodInstaller/Simple.pm) >= 0.006.009
Requires:	perl(Digest/MD5.pm) >= 2.360
Requires:	perl(Digest/SHA.pm) >= 5.450
Requires:	perl(File/chdir.pm) >= 0.100.200
Requires:	perl(File/Spec.pm)
Requires:	perl(Hash/FieldHash.pm) >= 0.060
Requires:	perl(Hash/Merge/Simple.pm) >= 0.040
Requires:	perl(Hash/StoredIterator.pm) >= 0.007
Requires:	perl(Import/Into.pm) >= 1.002.003
Requires:	perl(IPC/System/Simple.pm) >= 1.180
Requires:	perl(JSON/MaybeXS.pm) >= 1.003.005
Requires:	perl(List/MoreUtils.pm) >= 0.220
Requires:	perl(Modern/Perl.pm) >= 1.030
Requires:	perl(Module/Load.pm) >= 0.160
Requires:	perl(Path/Tiny.pm) >= 0.036
Requires:	perl(Perl6/Caller.pm) >= 0.100
Requires:	perl(Taint/Util.pm) >= 0.060
Requires:	perl(Text/Wrap.pm) >= 2009.030.500
Requires:	perl(Try/Tiny.pm) >= 0.020
Requires:	perl(Want.pm) >= 0.180
Requires:	perl(YAML/Any.pm) >= 0.700
Requires:	perl(autobox.pm) >= 2.800
Requires:	perl(autobox/Core.pm) >= 1.0
Requires:	perl(autobox/List/Util.pm) >= 20090629
Requires:	perl(autobox/dump.pm) >= 20090426
Requires:	perl(autodie.pm) >= 2.120
Requires:	perl(autovivification.pm) >= 0.060
Requires:	perl(if.pm)
Requires:	perl(indirect.pm) >= 0.240
Requires:	perl(parent.pm) >= 0.221
Requires:	perl(true/VERSION.pm) >= 0.160
Requires:	perl(utf8/all.pm) >= 0.015

# Filter underspecified dependencies
















Source44: import.info
%filter_from_requires /^perl(CLASS.pm)/d
%filter_from_requires /^perl(Carp.Fix.1_25.pm)/d
%filter_from_requires /^perl(Devel.Declare.MethodInstaller.Simple.pm)/d
%filter_from_requires /^perl(Hash.FieldHash.pm)/d
%filter_from_requires /^perl(Hash.StoredIterator.pm)/d
%filter_from_requires /^perl(Import.Into.pm)/d
%filter_from_requires /^perl(Module.Load.pm)/d
%filter_from_requires /^perl(Try.Tiny.pm)/d
%filter_from_requires /^perl(Want.pm)/d
%filter_from_requires /^perl(autobox.pm)/d
%filter_from_requires /^perl(autobox.Core.pm)/d
%filter_from_requires /^perl(autobox.List.Util.pm)/d
%filter_from_requires /^perl(autobox.dump.pm)/d
%filter_from_requires /^perl(autodie.pm)/d
%filter_from_requires /^perl(autovivification.pm)/d
%filter_from_requires /^perl(parent.pm)/d

%description
Perl 5 has a lot of warts. There's a lot of individual modules and techniques
out there to fix those warts. perl5i aims to pull the best of them together
into one module so you can turn them on all at once.

This includes adding features, changing existing core functions and changing
defaults. It will likely not be 100%% backwards compatible with Perl 5, though
it will be 99%%, perl5i will try to have a lexical effect.

Please add to this imaginary world and help make it real, either by telling
me what Perl looks like in your imagination
(http://github.com/schwern/perl5i/issues) or make a fork (forking on github is
like a branch you control) and implement it yourself.

%prep
%setup -q -n perl5i-v%{version}

# Fix coercion warnings in 0.pm and 1.pm as per existing fixes in 2.pm
%patch0
# not hasher-friendly
rm -f t/datetime.t t/time_compat.t

%build
perl Build.PL --installdirs=vendor --optimize="%{optflags}"
./Build

%install
./Build install --destdir=%{buildroot} --create_packlist=0
# %{_fixperms} -c %{buildroot}

%check
./Build test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{_bindir}/perl5i
%{perl_vendor_privlib}/perl5i.pm
%{perl_vendor_privlib}/perl5i/
%doc %{perl_vendor_privlib}/perl5ifaq.pod

%changelog
