# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bit/Vector.pm) perl(Class/Accessor.pm) perl(Encode.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request.pm) perl(IO/Select.pm) perl(IO/Socket/INET.pm) perl(IO/String.pm) perl(LWP/UserAgent.pm) perl(Math/BigInt.pm) perl(Thrift/XS/BinaryProtocol.pm) perl(Time/HiRes.pm) perl(base.pm) perl(threads.pm)
# END SourceDeps(oneline)
%define module_version 0.041
%define module_name perlcassa
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.041
Release: alt2
Summary: Perl Client for Apache Cassandra
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MK/MKJELLMAN/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
perlcassa is a native Perl client for interfacing with Apache Cassandra. It is essentially an API for Apache Thrift. It intelligently deals with CompositeType columns and ValidationClasses and encodes and packs them appropriately for the columnfamily specified. perlcassa deals with connection pooling, automatic retrying of insertions, automatic serialization and deserialization of primitive data types to pass column validation classes and more.

Although other Perl Cassandra clients exist such as Cassandra::Lite and Net::Cassandra they have not been updated for many of the changes in Cassandra releases >0.80. They al
so do not serialize and deserialize data making them not much more than an abstraction of the base Thrift calls. In my experence the difficulty lies in validation classes and being f
ault tolerant, not abstracting the Thrift code.

The module name perlcassa follows the naming convention of other Cassandra clients such as phpcassa and pycassa. This module is included on CPAN for convinence however, please see https://github.com/mkjellman/perlcassa for active development.

Note: This package does not support SuperColumns. Please look into CompositeType Comparators instead.
%prep
%setup -n %{module_name}-%{module_version}
rm -rf lib/Thrift*

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes examples
%perl_vendor_privlib/p*
%perl_vendor_privlib/C*

%changelog
