# BEGIN SourceDeps(oneline):
BuildRequires: libpcre2-devel perl(Alien/PCRE2.pm) perl(Data/Dumper.pm) perl(Devel/CheckLib.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(_charnames.pm)
# END SourceDeps(oneline)
%define module_name re-engine-PCRE2
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.17
Release: alt1
Summary: PCRE2 regular expression engine with jit
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RU/RURBAN/%{module_name}-%{version}.tar.gz

%description
Replaces perl's regex engine in a given lexical scope with PCRE2
regular expressions provided by libpcre2-8.

This provides jit support and faster matching, but may fail in corner
cases. See
pcre2compat.
It is typically 50%% faster than the core regex engine. See the BENCHMARKS entry elsewhere in this document.

The goal is to pass the full core re testsuite, identify all
problematic patterns and fall-back to the core re engine.  From the
1330 core tests, 46 currently fail. 90%% of the most popular cpan
modules do work fine already. Note that older perl version do fail
more regression tests. See the FAILING TESTS entry elsewhere in this document.

Note that some packaged libpcre2-8 libraries do not enable the jit
compiler. `CFLAGS=-fPIC cmake -DPCRE2_SUPPORT_JIT=ON; make'
PCRE2 then silently falls back to the normal PCRE2 compiler and matcher.

Check with:

  perl -Mre::engine::PCRE2 -e'print re::engine::PCRE2::JIT'

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_archlib/r*
%perl_vendor_autolib/*

%changelog
