Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		perl-true
Version:	1.0.2
Release:	alt4_17
Summary:	Automatically return a true value when a file is required
License:	Artistic-2.0
URL:		https://metacpan.org/release/true
Source0:	http://cpan.metacpan.org/authors/id/C/CH/CHOCOLATE/true-v%{version}.tar.gz
# ============= Module Build ====================
BuildRequires:	coreutils
BuildRequires:	findutils
BuildRequires:	gcc
BuildRequires:	perl-devel
BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel
BuildRequires:	perl(Config.pm)
BuildRequires:	perl(ExtUtils/Depends.pm)
BuildRequires:	perl(ExtUtils/MakeMaker.pm)
BuildRequires:	perl(File/Copy.pm)
# ============= Module Runtime ==================
BuildRequires:	perl(B/Hooks/OP/Annotation.pm)
BuildRequires:	perl(B/Hooks/OP/Check.pm)
BuildRequires:	perl(Devel/StackTrace.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(version.pm)
BuildRequires:	perl(warnings.pm)
BuildRequires:	perl(XSLoader.pm)
# ============= Test Suite ======================
BuildRequires:	perl(base.pm)
BuildRequires:	perl(File/Spec.pm)
BuildRequires:	perl(FindBin.pm)
BuildRequires:	perl(Function/Parameters.pm)
BuildRequires:	perl(lib.pm)
BuildRequires:	perl(Moo.pm)
BuildRequires:	perl(Test/More.pm)
# ============= Module Dependencies =============
# (none)

# Don't "provide" private Perl libs

Source44: import.info

%description
Perl's require built-in (and its use wrapper) requires the files it loads to
return a true value. This is usually accomplished by placing a single

	1;

statement at the end of included scripts or modules. It's not onerous to add
but it's a speed bump on the Perl novice's road to enlightenment. In addition,
it appears to be a non-sequitur to the uninitiated, leading some to attempt to
mitigate its appearance with a comment:

	1; # keep require happy
or:
	1; # Do not remove this line
or even:
	1; # Must end with this, because Perl is bogus.

This module packages this "return true" behavior so that it need not be
written explicitly. It can be used directly, but it is intended to be invoked
from the import method of a Modern::Perl-style module that enables modern Perl
features and conveniences and cleans up legacy Perl warts.

%prep
%setup -q -n true-v%{version}

%build
perl Makefile.PL \
	INSTALLDIRS=vendor \
	NO_PACKLIST=1 \
	NO_PERLLOCAL=1 \
	OPTIMIZE="%{optflags}"
%{make_build}

%install
%{makeinstall_std}
find %{buildroot} -type f -name '*.bs' -empty -delete
# %{_fixperms} -c %{buildroot}

%check
make test

%files
%doc --no-dereference LICENSE.md
%doc Changes README
%{perl_vendor_archlib}/auto/true/
%{perl_vendor_archlib}/true.pm
%{perl_vendor_archlib}/true/

%changelog
