%define module_version 0.2
%define module_name unigreek
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Module/Build.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Unicode/Normalize.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2
Release: alt1
Summary: convert from unigreek notation and back
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/N/NJ/NJFRANCK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use strict;
  use utf8;
  use feature qw(:5.10);
  use UniGreek qw(from_unigreek to_unigreek);

  binmode STDOUT,":utf8";

  my $unigreek = "Mh=nin a)/eide qea/";
  #result: .'.Y'.A.v.A .''.o.v.E.o .a.o.E
  say UniGreek::from_unigreek($unigreek);

  my $utf8 = ".'.Y'.A.v.A .''.o.v.E.o .a.o.E";
  #result: Mh=nin a)/eide qea/
  say UniGreek::to_unigreek($utf8);


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes
%perl_vendor_privlib/U*

%changelog
