# BEGIN SourceDeps(oneline):
BuildRequires: perl(Cwd.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Module/Path/More.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Versioning/Scheme/Perl.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name version-dev
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Set $VERSION based on version from git tags
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/version-dev

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Sometimes you do not explicitly set `$VERSION' in the module source code that
you're working on. For example, you're using the Dist::Zilla manpage with a plugin that
will set `$VERSION' during build, so only your built version of modules will
have their `$VERSION' set. Wen working with the unbuilt version, this sometimes
creates problem or annoyances when other modules or other code expect your
module to set `$VERSION'.

This pragma solves that annoyances. It installs a require hook that will check
if the module being loaded is: 1) inside the working directory; and 2) the
module's package does not have `$VERSION' set.

If the conditions are met, then first it will: 1) execute `git tag' to list
tags that look like a version number; 2) grab the most recent version; 3) bump
the version's dev part, e.g. v1.1 becomes v1.1_001 and v1.1_001 becomes
v1.1_002; 3) set the module's package `$VERSION' with this version.

=for Pod::Coverage .+

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/v*

%changelog
